/*
 * Decompiled with CFR 0.152.
 */
package com.securepay.nb.controller;

import com.securepay.nb.controller.IJWTResponse;
import com.securepay.nb.controller.JWTAuthService;
import com.securepay.nb.nbcommons.beans.IJWTInfo;
import com.securepay.nb.nbcommons.persistence.entity.User_Auth_Details;
import com.securepay.nb.nbcommons.persistence.entityService.User_Auth_DetailsService;
import com.securepay.nb.nbcommons.spi.persistence.BaseEntity;
import com.securepay.nb.nbcommons.spi.service.PGV2ApiRequest;
import com.securepay.nb.nbcommons.spi.service.PGV2ApiResponse;
import com.securepay.nb.nbcommons.spi.service.PGV2Request;
import java.time.LocalDateTime;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jwtauth"})
public class JWTAuthController {
    @Generated
    private static final Logger log;
    public static Logger logger;
    @Autowired
    private User_Auth_DetailsService userAuthDetailsService;

    private String getShortIdentifier() {
        return logger.getName();
    }

    @PostMapping(value={"/generatetoken"})
    public PGV2ApiResponse generateJWTToken(@RequestBody PGV2Request pGV2ApiRequest) throws Exception {
        IJWTInfo iJwtinfo = (IJWTInfo)pGV2ApiRequest.getGenericRequestDataObject(IJWTInfo.class);
        String token = JWTAuthService.generateJWSToken((IJWTInfo)iJwtinfo);
        User_Auth_Details auth_Details = new User_Auth_Details();
        auth_Details.setToken(token);
        auth_Details.setUser_id(iJwtinfo.getUser_id());
        auth_Details.setExpiry_time(LocalDateTime.now().plusMinutes(20L));
        auth_Details.setStatus(true);
        auth_Details.setUsers_bean(iJwtinfo.getUsersBean());
        auth_Details.setDomain(iJwtinfo.getDomain());
        this.userAuthDetailsService.create((BaseEntity)auth_Details, this.getShortIdentifier(), iJwtinfo.getUser_id());
        IJWTResponse iJWTResponse = new IJWTResponse();
        iJWTResponse.setUser_id(iJwtinfo.getUser_id());
        iJWTResponse.setUser_name(iJwtinfo.getLogin_input());
        iJWTResponse.setToken(token);
        return PGV2ApiResponse.getBasicSuccessResponse((Object)iJWTResponse, (String)"success");
    }

    @PostMapping(value={"/validateSessionToken"})
    public PGV2ApiResponse validateSessionToken(@RequestBody PGV2ApiRequest pGV2ApiRequest) throws Exception {
        IJWTInfo iJwtinfo = (IJWTInfo)pGV2ApiRequest.getGenericRequestDataObject(IJWTInfo.class);
        UsernamePasswordAuthenticationToken user = JWTAuthService.validateToken((String)iJwtinfo.getToken());
        if (user != null) {
            return PGV2ApiResponse.getEmptySuccessResponse((String)"valid");
        }
        return PGV2ApiResponse.builder().status(HttpStatus.UNAUTHORIZED).userMessage("Unauthorized - Access denied or session timed out!").sysErrorMessage("Unauthorized - Access denied or session timed out!").build();
    }

    static {
        logger = log = LoggerFactory.getLogger(JWTAuthController.class);
    }
}

