<?php
include "db.php";

$seo = mysqli_fetch_assoc(mysqli_query($conn,"SELECT * FROM seo_settings LIMIT 1"));

$success = "";
if(isset($_POST["submit"])){
    $name = $_POST["name"];
    $phone = $_POST["phone"];
    $email = $_POST["email"];
    $service = $_POST["service"];
    $message = $_POST["message"];

    mysqli_query($conn,"INSERT INTO enquiries(name,phone,email,service,message) VALUES('$name','$phone','$email','$service','$message')");
    $success = "Thank you! Your enquiry has been submitted successfully.";
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title><?php echo $seo['title']; ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <meta name="description" content="<?php echo $seo['meta_description']; ?>" />
  <meta name="keywords" content="<?php echo $seo['keywords']; ?>" />

  <!-- Dynamic SEO Codes -->
  <?php echo $seo["header_code"]; ?>
  <?php echo $seo["schema_code"]; ?>



  <!-- Google Font -->
  <link
    href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap"
    rel="stylesheet"
  />

  <!-- Icons (Font Awesome) -->
  <link
    rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css"
    integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA=="
    crossorigin="anonymous"
    referrerpolicy="no-referrer"
  />

  <style>
    :root {
      --primary: #1f7a4d;
      --primary-dark: #135135;
      --accent: #ffc857;
      --light-bg: #f7f9fc;
      --text-dark: #1f2933;
      --muted: #6b7280;
      --white: #ffffff;
      --danger: #e11d48;
      --shadow-soft: 0 15px 35px rgba(15, 23, 42, 0.08);
      --radius-lg: 18px;
      --radius-xl: 26px;
      --transition: all 0.3s ease;
    }

    * {
      box-sizing: border-box;
      margin: 0;
      padding: 0;
    }

    body {
      font-family: "Poppins", sans-serif;
      background: #f3f4f6;
      color: var(--text-dark);
      scroll-behavior: smooth;
      line-height: 1.6;
    }

    img {
      max-width: 100%;
      display: block;
    }

    a {
      text-decoration: none;
      color: inherit;
    }

    /* Layout helpers */
    .container {
      width: 100%;
      max-width: 1200px;
      margin: 0 auto;
      padding: 0 1.25rem;
    }

    .btn {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      gap: 0.4rem;
      border-radius: 999px;
      padding: 0.75rem 1.6rem;
      font-weight: 600;
      font-size: 0.95rem;
      border: none;
      cursor: pointer;
      transition: var(--transition);
      white-space: nowrap;
    }

    .btn-primary {
      background: linear-gradient(135deg, var(--primary), var(--primary-dark));
      color: var(--white);
      box-shadow: 0 10px 20px rgba(0, 128, 96, 0.4);
    }

    .btn-primary:hover {
      transform: translateY(-1px) scale(1.01);
      box-shadow: 0 16px 32px rgba(0, 128, 96, 0.45);
    }

    .btn-outline {
      border: 1px solid rgba(148, 163, 184, 0.8);
      background: rgba(255, 255, 255, 0.7);
      backdrop-filter: blur(10px);
      color: var(--text-dark);
    }

    .btn-outline:hover {
      border-color: var(--primary);
      color: var(--primary-dark);
      background: var(--white);
      box-shadow: 0 10px 20px rgba(15, 23, 42, 0.08);
    }

    .section {
      padding: 4.5rem 0;
    }

    .section-header {
      text-align: center;
      margin-bottom: 3rem;
    }

    .section-badge {
      display: inline-flex;
      align-items: center;
      gap: 0.3rem;
      font-size: 0.8rem;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      padding: 0.35rem 0.8rem;
      border-radius: 999px;
      background: rgba(31, 122, 77, 0.06);
      color: var(--primary-dark);
      font-weight: 600;
    }

    .section-title {
      font-size: 2rem;
      margin-top: 0.8rem;
      font-weight: 700;
    }

    .section-subtitle {
      max-width: 520px;
      margin: 0.75rem auto 0;
      color: var(--muted);
      font-size: 0.96rem;
    }

    /* NAVBAR */
    header {
      position: sticky;
      top: 0;
      z-index: 50;
      backdrop-filter: blur(16px);
      background: rgba(15, 23, 42, 0.90);
    }

    .nav {
      display: flex;
      align-items: center;
      justify-content: space-between;
      padding: 0.7rem 0;
    }

    .logo {
      display: flex;
      align-items: center;
      gap: 0.5rem;
      color: #f9fafb;
      font-weight: 700;
      letter-spacing: 0.04em;
    }

    .logo-icon {
      height: 38px;
      width: 38px;
      border-radius: 999px;
      background: radial-gradient(circle at 0 0, #22c55e 0, #16a34a 45%, #0f766e 100%);
      display: inline-flex;
      align-items: center;
      justify-content: center;
      color: white;
      font-size: 1.2rem;
      box-shadow: 0 8px 20px rgba(34, 197, 94, 0.7);
    }

    nav ul {
      display: flex;
      list-style: none;
      gap: 1.8rem;
      align-items: center;
    }

    nav ul li a {
      color: #e5e7eb;
      font-size: 0.95rem;
      position: relative;
    }

    nav ul li a::after {
      content: "";
      position: absolute;
      left: 0;
      bottom: -0.3rem;
      width: 0;
      height: 2px;
      background: var(--accent);
      transition: width 0.25s ease;
    }

    nav ul li a:hover::after {
      width: 100%;
    }

    .nav-actions {
      display: flex;
      gap: 0.7rem;
      align-items: center;
    }

    .nav-phone {
      display: flex;
      align-items: center;
      gap: 0.4rem;
      color: #e5e7eb;
      font-size: 0.88rem;
    }

    .nav-phone i {
      color: var(--accent);
      font-size: 0.95rem;
    }

    .menu-toggle {
      display: none;
      color: #e5e7eb;
      font-size: 1.4rem;
      cursor: pointer;
    }

    /* HERO */
    .hero {
      background: radial-gradient(circle at top left, rgba(56, 189, 248, 0.15), transparent 55%),
        radial-gradient(circle at bottom right, rgba(22, 163, 74, 0.23), transparent 55%),
        #020617;
      color: #e5e7eb;
      padding: 4.5rem 0 4rem;
    }

    .hero-inner {
      display: grid;
      grid-template-columns: minmax(0, 1.1fr) minmax(0, 0.9fr);
      gap: 3.2rem;
      align-items: center;
    }

    .hero-tagline {
      display: inline-flex;
      align-items: center;
      gap: 0.5rem;
      padding: 0.3rem 0.75rem;
      border-radius: 999px;
      background: rgba(15, 23, 42, 0.9);
      border: 1px solid rgba(148, 163, 184, 0.6);
      font-size: 0.8rem;
      margin-bottom: 1rem;
    }

    .hero-tagline i {
      color: var(--accent);
    }

    .hero h1 {
      font-size: 2.5rem;
      line-height: 1.1;
      margin-bottom: 1rem;
    }

    .hero h1 span {
      color: var(--accent);
    }

    .hero-text {
      color: #cbd5f5;
      margin-bottom: 1.75rem;
      font-size: 0.98rem;
      max-width: 500px;
    }

    .hero-highlights {
      display: flex;
      flex-wrap: wrap;
      gap: 1rem;
      margin-bottom: 1.5rem;
    }

    .hero-highlight-pill {
      display: inline-flex;
      align-items: center;
      gap: 0.4rem;
      padding: 0.35rem 0.85rem;
      border-radius: 999px;
      background: rgba(15, 23, 42, 0.9);
      border: 1px dashed rgba(148, 163, 184, 0.7);
      font-size: 0.8rem;
      color: #e5e7eb;
    }

    .hero-highlight-pill i {
      color: #22c55e;
    }

    .hero-cta {
      display: flex;
      flex-wrap: wrap;
      gap: 0.75rem;
      align-items: center;
      margin-bottom: 1.5rem;
    }

    .hero-small-note {
      font-size: 0.8rem;
      color: #9ca3af;
    }

    .hero-meta {
      display: flex;
      flex-wrap: wrap;
      gap: 1.5rem;
      margin-top: 0.75rem;
      font-size: 0.8rem;
      color: #9ca3af;
    }

    .hero-meta span {
      display: inline-flex;
      align-items: center;
      gap: 0.3rem;
    }

    .hero-meta i {
      color: #22c55e;
    }

    .hero-media-card {
      background: rgba(15, 23, 42, 0.92);
      border-radius: 28px;
      padding: 1rem;
      border: 1px solid rgba(148, 163, 184, 0.4);
      box-shadow: 0 25px 35px rgba(15, 23, 42, 0.75);
      position: relative;
      overflow: hidden;
    }

    .hero-image-wrap {
      border-radius: 24px;
      overflow: hidden;
      position: relative;
      max-height: 340px;
    }

    .hero-image-wrap img {
      width: 100%;
      height: 100%;
      object-fit: cover;
      transform: scale(1.03);
      transition: transform 0.6s ease;
    }

    .hero-media-card:hover img {
      transform: scale(1.08);
    }

    .hero-floating-card {
      position: absolute;
      left: 1.2rem;
      bottom: 1.4rem;
      padding: 0.7rem 0.9rem;
      background: rgba(15, 23, 42, 0.9);
      border-radius: 18px;
      border: 1px solid rgba(148, 163, 184, 0.75);
      backdrop-filter: blur(12px);
      display: flex;
      align-items: center;
      gap: 0.6rem;
      color: #f9fafb;
      font-size: 0.8rem;
    }

    .hero-floating-card i {
      color: #22c55e;
      font-size: 1rem;
    }

    .hero-floating-card small {
      display: block;
      color: #9ca3af;
      font-size: 0.72rem;
    }

    .hero-badge-top {
      position: absolute;
      right: 1.1rem;
      top: 1.1rem;
      padding: 0.5rem 0.9rem;
      border-radius: 999px;
      background: rgba(22, 163, 74, 0.2);
      color: #bbf7d0;
      font-size: 0.78rem;
      border: 1px solid rgba(34, 197, 94, 0.7);
    }

    /* SERVICES */
    .services {
      background: var(--light-bg);
    }

    .services-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(230px, 1fr));
      gap: 1.5rem;
    }

    .service-card {
      background: var(--white);
      border-radius: var(--radius-lg);
      padding: 1.4rem 1.3rem;
      box-shadow: var(--shadow-soft);
      border: 1px solid rgba(148, 163, 184, 0.2);
      display: flex;
      flex-direction: column;
      gap: 0.6rem;
      position: relative;
      overflow: hidden;
    }

    .service-image {
      width: 100%;
      border-radius: 14px;
      overflow: hidden;
      margin-bottom: 0.7rem;
      max-height: 160px;
    }

    .service-image img {
      width: 100%;
      height: 100%;
      object-fit: cover;
      transition: transform 0.4s ease;
    }

    .service-card:hover .service-image img {
      transform: scale(1.06);
    }

    .service-icon {
      height: 38px;
      width: 38px;
      border-radius: 999px;
      background: rgba(22, 163, 74, 0.1);
      display: inline-flex;
      align-items: center;
      justify-content: center;
      font-size: 1.1rem;
      color: var(--primary-dark);
    }

    .service-title {
      font-weight: 600;
      font-size: 1.02rem;
    }

    .service-text {
      font-size: 0.9rem;
      color: var(--muted);
    }

    .pill-label {
      display: inline-flex;
      align-items: center;
      gap: 0.25rem;
      padding: 0.25rem 0.6rem;
      border-radius: 999px;
      background: rgba(148, 163, 184, 0.15);
      font-size: 0.75rem;
      color: var(--muted);
    }

    /* ABOUT / WHY */
    .two-column {
      display: grid;
      grid-template-columns: minmax(0, 1.1fr) minmax(0, 0.9fr);
      gap: 2.5rem;
      align-items: center;
    }

    .about-image-wrap {
      border-radius: var(--radius-xl);
      overflow: hidden;
      box-shadow: var(--shadow-soft);
      border: 1px solid rgba(148, 163, 184, 0.2);
    }

    .about-image-wrap img {
      height: 100%;
      width: 100%;
      object-fit: cover;
    }

    .feature-list {
      display: grid;
      gap: 0.7rem;
      margin-top: 1rem;
    }

    .feature-item {
      display: flex;
      gap: 0.6rem;
      align-items: flex-start;
      font-size: 0.9rem;
      color: var(--muted);
    }

    .feature-item i {
      color: #22c55e;
      margin-top: 0.15rem;
    }

    /* PROCESS */
    .process-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(210px, 1fr));
      gap: 1.4rem;
    }

    .step-card {
      background: #0f172a;
      color: #e5e7eb;
      border-radius: var(--radius-lg);
      padding: 1.3rem 1.2rem;
      position: relative;
      overflow: hidden;
      box-shadow: var(--shadow-soft);
    }

    .step-number {
      position: absolute;
      top: -12px;
      right: 14px;
      font-size: 3rem;
      font-weight: 800;
      opacity: 0.08;
    }

    .step-title {
      font-weight: 600;
      margin-bottom: 0.4rem;
      font-size: 1.02rem;
    }

    .step-text {
      font-size: 0.88rem;
      color: #cbd5f5;
    }

    /* PRICING */
    .pricing-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(260px, 1fr));
      gap: 1.5rem;
    }

    .pricing-card {
      background: var(--white);
      border-radius: var(--radius-xl);
      padding: 1.8rem 1.6rem;
      box-shadow: var(--shadow-soft);
      border: 1px solid rgba(148, 163, 184, 0.3);
      position: relative;
    }

    .pricing-badge {
      position: absolute;
      top: 1.2rem;
      right: 1.3rem;
      padding: 0.35rem 0.8rem;
      border-radius: 999px;
      background: rgba(22, 163, 74, 0.09);
      color: var(--primary-dark);
      font-size: 0.75rem;
      font-weight: 600;
    }

    .pricing-title {
      font-weight: 600;
      font-size: 1.05rem;
      margin-bottom: 0.3rem;
    }

    .pricing-price {
      font-size: 1.4rem;
      font-weight: 700;
      color: var(--primary-dark);
      margin: 0.5rem 0;
    }

    .pricing-period {
      font-size: 0.8rem;
      color: var(--muted);
    }

    .pricing-features {
      margin: 0.8rem 0 1.2rem;
      list-style: none;
      display: grid;
      gap: 0.4rem;
      font-size: 0.86rem;
      color: var(--muted);
    }

    .pricing-features li i {
      color: #22c55e;
      margin-right: 0.4rem;
    }

    /* TESTIMONIALS */
    .testimonials {
      background: #020617;
      color: #e5e7eb;
    }

    .testimonials-grid {
      display: grid;
      grid-template-columns: minmax(0, 1.1fr) minmax(0, 0.9fr);
      gap: 2.5rem;
      align-items: center;
    }

    .testimonial-card {
      background: rgba(15, 23, 42, 0.9);
      border-radius: var(--radius-lg);
      padding: 1.4rem 1.3rem;
      border: 1px solid rgba(148, 163, 184, 0.4);
      box-shadow: 0 18px 35px rgba(15, 23, 42, 0.9);
      position: relative;
    }

    .testimonial-quote {
      font-size: 0.95rem;
      margin-bottom: 0.9rem;
      color: #e5e7eb;
    }

    .testimonial-user {
      display: flex;
      align-items: center;
      gap: 0.6rem;
    }

    .testimonial-avatar {
      height: 38px;
      width: 38px;
      border-radius: 999px;
      overflow: hidden;
      flex-shrink: 0;
    }

    .testimonial-name {
      font-size: 0.9rem;
      font-weight: 600;
    }

    .testimonial-meta {
      font-size: 0.78rem;
      color: #9ca3af;
    }

    .star-rating {
      color: #facc15;
      font-size: 0.85rem;
      margin-bottom: 0.4rem;
    }

    /* FAQ */
    .faq-grid {
      display: grid;
      grid-template-columns: minmax(0, 1.1fr) minmax(0, 0.9fr);
      gap: 2.5rem;
    }

    .faq-item {
      background: var(--white);
      border-radius: var(--radius-lg);
      padding: 1rem 1rem;
      border: 1px solid rgba(148, 163, 184, 0.35);
      margin-bottom: 0.8rem;
      cursor: pointer;
      transition: var(--transition);
    }

    .faq-item:hover {
      box-shadow: var(--shadow-soft);
      transform: translateY(-1px);
    }

    .faq-question {
      display: flex;
      justify-content: space-between;
      gap: 1rem;
      align-items: center;
      font-size: 0.95rem;
      font-weight: 500;
    }

    .faq-answer {
      margin-top: 0.55rem;
      font-size: 0.85rem;
      color: var(--muted);
      display: none;
    }

    .faq-item.active .faq-answer {
      display: block;
    }

    /* CONTACT */
    .contact {
      background: var(--light-bg);
    }

    .contact-grid {
      display: grid;
      grid-template-columns: minmax(0, 1.05fr) minmax(0, 0.95fr);
      gap: 2.4rem;
      align-items: flex-start;
    }

    .contact-card {
      background: var(--white);
      border-radius: var(--radius-xl);
      padding: 1.7rem 1.5rem;
      box-shadow: var(--shadow-soft);
      border: 1px solid rgba(148, 163, 184, 0.3);
    }

    .contact-card h3 {
      font-size: 1.2rem;
      margin-bottom: 0.3rem;
    }

    .contact-card p {
      font-size: 0.9rem;
      color: var(--muted);
      margin-bottom: 1.2rem;
    }

    .contact-form {
      display: grid;
      gap: 0.9rem;
    }

    .form-group {
      display: grid;
      gap: 0.25rem;
    }

    .form-group label {
      font-size: 0.82rem;
      font-weight: 500;
    }

    .form-group input,
    .form-group textarea {
      padding: 0.65rem 0.75rem;
      border-radius: 0.75rem;
      border: 1px solid rgba(148, 163, 184, 0.7);
      font-size: 0.88rem;
      font-family: inherit;
      outline: none;
      transition: var(--transition);
      background: #f9fafb;
    }

    .form-group input:focus,
    .form-group textarea:focus {
      border-color: var(--primary);
      box-shadow: 0 0 0 2px rgba(34, 197, 94, 0.18);
      background: #ffffff;
    }

    .form-group textarea {
      min-height: 120px;
      resize: vertical;
    }

    .contact-info-list {
      display: grid;
      gap: 0.8rem;
      margin-top: 1rem;
      font-size: 0.9rem;
      color: var(--muted);
    }

    .contact-info-item {
      display: flex;
      gap: 0.6rem;
      align-items: flex-start;
    }

    .contact-info-item i {
      color: var(--primary);
      margin-top: 0.15rem;
    }

    .map-card {
      background: #020617;
      border-radius: var(--radius-xl);
      padding: 1.4rem 1.3rem;
      border: 1px solid rgba(148, 163, 184, 0.45);
      color: #e5e7eb;
      box-shadow: 0 20px 35px rgba(15, 23, 42, 0.8);
    }

    .map-card h3 {
      margin-bottom: 0.6rem;
    }

    .map-card p {
      font-size: 0.9rem;
      color: #9ca3af;
      margin-bottom: 0.9rem;
    }

    .map-image {
      border-radius: 16px;
      overflow: hidden;
      border: 1px solid rgba(148, 163, 184, 0.6);
      margin-bottom: 0.8rem;
    }

    .map-meta {
      font-size: 0.8rem;
      color: #9ca3af;
      display: flex;
      flex-wrap: wrap;
      gap: 0.9rem;
    }

    .map-meta span {
      display: inline-flex;
      gap: 0.35rem;
      align-items: center;
    }

    .map-meta span i {
      color: #22c55e;
    }

    /* FOOTER */
    footer {
      background: #020617;
      color: #9ca3af;
      padding: 2.2rem 0 1.4rem;
    }

    .footer-grid {
      display: grid;
      grid-template-columns: minmax(0, 1.3fr) repeat(2, minmax(0, 0.7fr));
      gap: 2.3rem;
      font-size: 0.85rem;
    }

    .footer-brand p {
      margin-top: 0.6rem;
    }

    .footer-links-title {
      font-weight: 600;
      margin-bottom: 0.7rem;
      color: #e5e7eb;
    }

    .footer-links {
      display: grid;
      gap: 0.4rem;
    }

    .footer-links a {
      color: #9ca3af;
      font-size: 0.83rem;
    }

    .footer-links a:hover {
      color: #e5e7eb;
    }

    .footer-bottom {
      margin-top: 1.4rem;
      border-top: 1px solid rgba(148, 163, 184, 0.4);
      padding-top: 0.9rem;
      display: flex;
      justify-content: space-between;
      flex-wrap: wrap;
      gap: 0.6rem;
      font-size: 0.78rem;
    }

    .footer-bottom a {
      color: #9ca3af;
    }

    .footer-bottom a:hover {
      color: #e5e7eb;
    }

    /* RESPONSIVE */
    @media (max-width: 992px) {
      .hero-inner,
      .two-column,
      .testimonials-grid,
      .faq-grid,
      .contact-grid,
      .footer-grid {
        grid-template-columns: 1fr;
      }

      .hero-inner {
        gap: 2.5rem;
      }

      .footer-grid {
        gap: 1.8rem;
      }
    }

    @media (max-width: 768px) {
      nav ul {
        position: absolute;
        top: 56px;
        left: 0;
        width: 100%;
        background: rgba(2, 6, 23, 0.98);
        flex-direction: column;
        padding: 0.7rem 1.2rem 1rem;
        border-bottom: 1px solid rgba(148, 163, 184, 0.5);
        transform: translateY(-140%);
        opacity: 0;
        pointer-events: none;
        transition: var(--transition);
      }

      nav ul.show {
        transform: translateY(0);
        opacity: 1;
        pointer-events: auto;
      }

      .nav-actions {
        display: none;
      }

      .menu-toggle {
        display: block;
      }

      .hero {
        padding-top: 3.2rem;
      }

      .hero h1 {
        font-size: 2.1rem;
      }

      .section {
        padding: 3.3rem 0;
      }
    }

    @media (max-width: 480px) {
      .hero h1 {
        font-size: 1.85rem;
      }

      .hero-media-card {
        padding: 0.7rem;
      }

      .hero-floating-card {
        left: 0.8rem;
        bottom: 1rem;
      }

      .hero-badge-top {
        right: 0.7rem;
        top: 0.8rem;
      }
    }
  </style>
</head>

<body>
  <!-- HEADER -->
  <header>
    <div class="container nav">
      <div class="logo">
        <div class="logo-icon">
          <i class="fa-solid fa-shield-bug"></i>
        </div>
        <div>
          <div style="font-size: 0.9rem;">PEST CONTROL</div>
          <div style="font-size: 0.72rem; opacity: 0.8;">KING</div>
        </div>
      </div>

      <nav>
        <ul id="nav-menu">
          <li><a href="#home">Home</a></li>
          <li><a href="#services">Services</a></li>
          <li><a href="#about">Why Us</a></li>
          <li><a href="#pricing">Pricing</a></li>
          <li><a href="#faq">FAQ</a></li>
          <li><a href="#contact">Contact</a></li>
        </ul>
      </nav>

      <div class="nav-actions">
        <div class="nav-phone">
          <i class="fa-solid fa-phone"></i>
          <span>+91 8305961850<br /><small>24×7 Support</small></span>
        </div>
        <a href="#contact" class="btn btn-primary" style="font-size: 0.85rem;">
          Book Inspection
        </a>
      </div>

      <div class="menu-toggle" id="menu-toggle">
        <i class="fa-solid fa-bars-staggered"></i>
      </div>
    </div>
  </header>

  <!-- HERO -->
  <section class="hero" id="home">
    <div class="container hero-inner">
      <div>
        <div class="hero-tagline">
          <i class="fa-solid fa-wand-magic-sparkles"></i>
          <span>Fast • Safe • Odourless Treatment</span>
        </div>
        <h1>
          Pest-free home with<br />
          <span>Pest Control King</span>
        </h1>
        <p class="hero-text">
          Professional pest control services in
          <strong>Potiyakla Chouk, Durg Bhilai, Chhattisgarh</strong>. Eco-friendly chemicals, trained
          experts and same-day service for homes, offices & shops.
        </p>

        <div class="hero-highlights">
          <div class="hero-highlight-pill">
            <i class="fa-solid fa-circle-check"></i> 100% Safe for Kids & Pets
          </div>
          <div class="hero-highlight-pill">
            <i class="fa-solid fa-clock"></i> Same-Day Treatment
          </div>
          <div class="hero-highlight-pill">
            <i class="fa-solid fa-shield-halved"></i> Up to 1 Year Warranty*
          </div>
        </div>

        <div class="hero-cta">
          <a href="#contact" class="btn btn-primary">
            <i class="fa-solid fa-calendar-check"></i>
            Book Free Inspection
          </a>
          <a href="#services" class="btn btn-outline">
            <i class="fa-solid fa-layer-group"></i>
            View All Services
          </a>
        </div>

        <div class="hero-small-note">
          *Warranty depends on service package • No hidden charges • GST invoice available.
        </div>

        <div class="hero-meta">
          <span><i class="fa-solid fa-users"></i> 1500+ Homes Treated</span>
          <span><i class="fa-solid fa-star"></i> 4.9/5 Customer Rating</span>
        </div>
      </div>

      <div class="hero-media-card">
        <div class="hero-image-wrap">
          <!-- Hero image -->
          <img
            src="img/hero.jpg"
            alt="Technician performing pest control service"
          />
          <div class="hero-floating-card">
            <i class="fa-solid fa-spray-can-sparkles"></i>
            <div>
              <strong>Complete Pest Protection</strong>
              <small>Termites • Cockroaches • Rodents • Bed Bugs</small>
            </div>
          </div>
          <div class="hero-badge-top">
            <i class="fa-solid fa-leaf"></i> Eco-Friendly Chemicals
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- SERVICES -->
  <section class="section services" id="services">
    <div class="container">
      <div class="section-header">
        <div class="section-badge">
          <i class="fa-solid fa-briefcase-medical"></i>
          Our Services
        </div>
        <h2 class="section-title">All-round Pest Control Solutions</h2>
        <p class="section-subtitle">
          Whether it’s cockroaches in the kitchen, termites in the furniture or rodents in the warehouse – we have a
          specialised treatment for every problem.
        </p>
      </div>

      <div class="services-grid">
        <!-- Cockroach -->
        <div class="service-card">
          <div class="service-image">
            <img
              src="img/kokroch.jpg"
              alt="Cockroach pest control treatment"
            />
          </div>
          <span class="pill-label">
            <i class="fa-solid fa-bolt"></i> Kitchen Special
          </span>
          <div class="service-icon">
            <i class="fa-solid fa-bug"></i>
          </div>
          <h3 class="service-title">Cockroach & Ant Control</h3>
          <p class="service-text">
            Odourless gel & spray treatment for kitchens, bathrooms and drains. Long-lasting control of cockroaches,
            ants & other crawling insects.
          </p>
        </div>

        <!-- Termite -->
        <div class="service-card">
          <div class="service-image">
            <img
              src="img/termite.jpg"
              alt="Termite treatment on wooden furniture"
            />
          </div>
          <span class="pill-label">
            <i class="fa-solid fa-shield"></i> 3–5 Year Warranty
          </span>
          <div class="service-icon">
            <i class="fa-solid fa-house-circle-check"></i>
          </div>
          <h3 class="service-title">Termite Control</h3>
          <p class="service-text">
            Advanced drill-fill-seal method to protect doors, furniture & walls from termites. Ideal for new as well as
            existing buildings.
          </p>
        </div>

        <!-- Bed Bugs -->
        <div class="service-card">
          <div class="service-image">
            <img
              src="img/bed.jpg"
              alt="Bed bug control service"
            />
          </div>
          <span class="pill-label">
            <i class="fa-solid fa-moon"></i> Sleep Peacefully
          </span>
          <div class="service-icon">
            <i class="fa-solid fa-bed-pulse"></i>
          </div>
          <h3 class="service-title">Bed Bug Treatment</h3>
          <p class="service-text">
            Two-step treatment plan that targets bed bugs hidden in mattresses, sofas & furniture without damaging your
            belongings.
          </p>
        </div>

        <!-- Rodent -->
        <div class="service-card">
          <div class="service-image">
            <img
              src="img/rat.jpg"
              alt="Rodent and rat control service"
            />
          </div>
          <span class="pill-label">
            <i class="fa-solid fa-warehouse"></i> Homes & Warehouses
          </span>
          <div class="service-icon">
            <i class="fa-solid fa-otter"></i>
          </div>
          <h3 class="service-title">Rat & Rodent Control</h3>
          <p class="service-text">
            Traps, bait stations & entry-point sealing to keep rats away from homes, godowns, restaurants & shops.
          </p>
        </div>

        <!-- Mosquito -->
        <div class="service-card">
          <div class="service-image">
            <img
              src="img/mas.jpg"
              alt="Mosquito fogging and control"
            />
          </div>
          <span class="pill-label">
            <i class="fa-solid fa-city"></i> Outdoor Coverage
          </span>
          <div class="service-icon">
            <i class="fa-solid fa-mosquito"></i>
          </div>
          <h3 class="service-title">Mosquito & Fly Control</h3>
          <p class="service-text">
            ULV fogging and residual spray solutions for societies, farm houses & commercial complexes to reduce
            mosquito breeding.
          </p>
        </div>

        <!-- Commercial -->
        <div class="service-card">
          <div class="service-image">
            <img
              src="img/com.jpg"
              alt="Commercial and industrial pest control"
            />
          </div>
          <span class="pill-label">
            <i class="fa-solid fa-building"></i> AMC Available
          </span>
          <div class="service-icon">
            <i class="fa-solid fa-briefcase"></i>
          </div>
          <h3 class="service-title">Commercial Pest Management</h3>
          <p class="service-text">
            Custom pest control plans for offices, restaurants, schools, hospitals & factories with regular inspections
            and reports.
          </p>
        </div>
      </div>
    </div>
  </section>

  <!-- ABOUT / WHY US -->
  <section class="section" id="about">
    <div class="container two-column">
      <div>
        <div class="section-badge">
          <i class="fa-solid fa-crown"></i>
          Why Pest Control King
        </div>
        <h2 class="section-title" style="text-align: left;">
          Local Experts with Professional Standards
        </h2>
        <p style="color: var(--muted); font-size: 0.95rem; margin-top: 0.6rem;">
          Being based in <strong>Potiyakla Chouk, Durg Bhilai</strong>, we understand the common pest problems in
          Chhattisgarh very well. Our team uses certified chemicals, modern equipment and safety-first protocols for
          every job.
        </p>

        <div class="feature-list">
          <div class="feature-item">
            <i class="fa-solid fa-user-shield"></i>
            <p><strong>Trained & Verified Technicians</strong><br />All staff are fully trained on safe chemical usage,
              PPE & customer hygiene practices.</p>
          </div>

          <div class="feature-item">
            <i class="fa-solid fa-recycle"></i>
            <p><strong>Eco-friendly & Low Odour</strong><br />We choose WHO-approved chemicals that are safe for kids,
              elderly & pets when used as directed.</p>
          </div>

          <div class="feature-item">
            <i class="fa-solid fa-sack-dollar"></i>
            <p><strong>Transparent & Affordable Pricing</strong><br />No surprise charges – you know your cost before we
              start the treatment.</p>
          </div>

          <div class="feature-item">
            <i class="fa-solid fa-file-shield"></i>
            <p><strong>Service Warranty on Selected Plans</strong><br />If pests come back within the warranty period,
              we re-treat at no extra service charge.</p>
          </div>
        </div>
      </div>

      <div class="about-image-wrap">
        <!-- About image -->
        <img
          src="img/fo.jpg"
          alt="Pest control team at work"
        />
      </div>
    </div>
  </section>

  <!-- PROCESS -->
  <section class="section">
    <div class="container">
      <div class="section-header">
        <div class="section-badge">
          <i class="fa-solid fa-route"></i>
          Our Process
        </div>
        <h2 class="section-title">How We Make Your Space Pest-Free</h2>
        <p class="section-subtitle">
          Simple, hassle-free and transparent process designed to give you maximum comfort with minimum disruption to
          your routine.
        </p>
      </div>

      <div class="process-grid">
        <div class="step-card">
          <div class="step-number">01</div>
          <h3 class="step-title">Free Inspection & Quote</h3>
          <p class="step-text">
            Our expert visits your site, checks the infestation level & explains suitable treatment options with a clear
            quotation.
          </p>
        </div>

        <div class="step-card">
          <div class="step-number">02</div>
          <h3 class="step-title">Safe Treatment Execution</h3>
          <p class="step-text">
            We schedule the treatment at your preferred time using protective covers, PPE & child-safe methods.
          </p>
        </div>

        <div class="step-card">
          <div class="step-number">03</div>
          <h3 class="step-title">Post-Service Guidelines</h3>
          <p class="step-text">
            You get simple do’s & don’ts after the service – including cleaning tips and safety instructions.
          </p>
        </div>

        <div class="step-card">
          <div class="step-number">04</div>
          <h3 class="step-title">Follow-up & Warranty Visits</h3>
          <p class="step-text">
            For AMC / warranty plans, we schedule follow-up visits to keep pests away round the year.
          </p>
        </div>
      </div>
    </div>
  </section>

  <!-- PRICING -->
  <section class="section" id="pricing">
    <div class="container">
      <div class="section-header">
        <div class="section-badge">
          <i class="fa-solid fa-tags"></i>
          Pricing Plans
        </div>
        <h2 class="section-title">Flexible Plans for Every Property</h2>
        <p class="section-subtitle">
          Below prices are indicative. Final quotation depends on area size, infestation level and custom requirements.
        </p>
      </div>

      <div class="pricing-grid">
        <!-- Basic -->
        <div class="pricing-card">
          <div class="pricing-badge">Popular for 1 BHK</div>
          <h3 class="pricing-title">Basic Pest Control</h3>
          <div class="pricing-price">₹799 <span class="pricing-period">/ one-time*</span></div>
          <ul class="pricing-features">
            <li><i class="fa-solid fa-check"></i> Cockroach, ants & general pests</li>
            <li><i class="fa-solid fa-check"></i> Kitchen + 1 bathroom + balcony</li>
            <li><i class="fa-solid fa-check"></i> Odourless gel & spray treatment</li>
            <li><i class="fa-solid fa-check"></i> 30–45 minutes average time</li>
          </ul>
          <button class="btn btn-primary" onclick="scrollToContact()">
            Get Exact Quote
          </button>
        </div>

        <!-- Annual -->
        <div class="pricing-card">
          <div class="pricing-badge">Best Value</div>
          <h3 class="pricing-title">Annual Protection Plan</h3>
          <div class="pricing-price">₹2,499 <span class="pricing-period">/ year*</span></div>
          <ul class="pricing-features">
            <li><i class="fa-solid fa-check"></i> 3–4 services in a year</li>
            <li><i class="fa-solid fa-check"></i> Free callbacks in warranty</li>
            <li><i class="fa-solid fa-check"></i> Ideal for families & rentals</li>
            <li><i class="fa-solid fa-check"></i> Priority booking support</li>
          </ul>
          <button class="btn btn-primary" onclick="scrollToContact()">
            Talk to Our Expert
          </button>
        </div>

        <!-- Termite -->
        <div class="pricing-card">
          <div class="pricing-badge">Long Term Safety</div>
          <h3 class="pricing-title">Termite Treatment Plan</h3>
          <div class="pricing-price">On Inspection</div>
          <ul class="pricing-features">
            <li><i class="fa-solid fa-check"></i> Pre / Post construction treatment</li>
            <li><i class="fa-solid fa-check"></i> 3–5 year service warranty</li>
            <li><i class="fa-solid fa-check"></i> Detailed service documentation</li>
            <li><i class="fa-solid fa-check"></i> Suitable for homes & offices</li>
          </ul>
          <button class="btn btn-primary" onclick="scrollToContact()">
            Book Free Inspection
          </button>
        </div>
      </div>
    </div>
  </section>

  <!-- TESTIMONIALS -->
  <section class="section testimonials">
    <div class="container testimonials-grid">
      <div>
        <div class="section-badge">
          <i class="fa-solid fa-comment-dots"></i>
          Happy Customers
        </div>
        <h2 class="section-title" style="color: #e5e7eb; text-align: left;">
          Trusted by Families & Businesses in Durg Bhilai
        </h2>
        <p style="color: #9ca3af; font-size: 0.94rem; margin-top: 0.6rem;">
          From small flats to large warehouses, Pest Control King has helped hundreds of customers stay pest-free – on
          time and on budget.
        </p>
        <div style="margin-top: 1.2rem; display: flex; flex-wrap: wrap; gap: 1rem; font-size: 0.86rem; color: #9ca3af;">
          <span><i class="fa-solid fa-shield-heart"></i> 100% Satisfaction Focus</span>
          <span><i class="fa-solid fa-user-tie"></i> Dedicated Customer Support</span>
        </div>
      </div>

      <div class="testimonial-card">
        <div class="star-rating">
          <i class="fa-solid fa-star"></i><i class="fa-solid fa-star"></i><i class="fa-solid fa-star"></i><i
            class="fa-solid fa-star"></i><i class="fa-solid fa-star-half-stroke"></i>
        </div>
        <p class="testimonial-quote">
          “Very professional team. They did cockroach and termite treatment at my 3 BHK in Bhilai. The technician
          explained everything clearly and they also followed up after 15 days. Highly recommended.”
        </p>
        <div class="testimonial-user">
          <div class="testimonial-avatar">
            <img
              src="https://images.pexels.com/photos/3760853/pexels-photo-3760853.jpeg?auto=compress&cs=tinysrgb&w=400"
              alt="Happy customer"
            />
          </div>
          <div>
            <div class="testimonial-name">Rahul Verma</div>
            <div class="testimonial-meta">Home Owner • Durg</div>
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- FAQ -->
  <section class="section" id="faq">
    <div class="container faq-grid">
      <div>
        <div class="section-badge">
          <i class="fa-solid fa-circle-question"></i>
          FAQ
        </div>
        <h2 class="section-title" style="text-align: left;">Frequently Asked Questions</h2>
        <p style="color: var(--muted); font-size: 0.94rem; margin-top: 0.6rem;">
          Still confused about safety, preparation or pricing? Here are answers to the questions we get asked most
          often.
        </p>
      </div>

      <div>
        <div class="faq-item">
          <div class="faq-question">
            <span>Is the treatment safe for kids, elderly people and pets?</span>
            <i class="fa-solid fa-chevron-down"></i>
          </div>
          <div class="faq-answer">
            Yes. We use branded, WHO-approved chemicals in recommended doses. We may request you to step out for
            1–2 hours in some cases. All details are explained before starting the service.
          </div>
        </div>

        <div class="faq-item">
          <div class="faq-question">
            <span>How long does one pest control service take?</span>
            <i class="fa-solid fa-chevron-down"></i>
          </div>
          <div class="faq-answer">
            For a standard 1–2 BHK flat, treatment usually takes 30–60 minutes depending on infestation level and number
            of rooms. Commercial sites may require more time.
          </div>
        </div>

        <div class="faq-item">
          <div class="faq-question">
            <span>Do I need to empty my kitchen cupboards?</span>
            <i class="fa-solid fa-chevron-down"></i>
          </div>
          <div class="faq-answer">
            For regular cockroach treatment, only basic access is needed. In case of heavy infestation, our team may
            request you to empty specific cupboards or shelves for better results.
          </div>
        </div>

        <div class="faq-item">
          <div class="faq-question">
            <span>What if pests come back after treatment?</span>
            <i class="fa-solid fa-chevron-down"></i>
          </div>
          <div class="faq-answer">
            If you have taken a warranty or AMC plan, we will provide free re-treatment within the warranty period. For
            one-time services, small top-up charges may apply.
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- CONTACT -->
  <section class="section contact" id="contact">
    <div class="container contact-grid">
      <div class="contact-card">
        <h3>Book a Free Site Visit</h3>
        <p>
          Share your details and our team will call you to schedule a free inspection and provide an exact quotation
          based on your requirement.
        </p>

      <form class="contact-form" method="POST">
  <div class="form-group">
    <label>Full Name</label>
    <input name="name" type="text" placeholder="Enter your name" required >
  </div>

  <div class="form-group">
    <label>Mobile Number</label>
    <input name="phone" type="tel" placeholder="Enter your mobile number" required >
  </div>

  <div class="form-group">
    <label>Email (optional)</label>
    <input name="email" type="email" placeholder="you@example.com" >
  </div>

  <div class="form-group">
    <label>Required Service</label>
    <input name="service" type="text" placeholder="Cockroach, Termite, Bed Bugs, etc.">
  </div>

  <div class="form-group">
    <label>Additional Details</label>
    <textarea name="message" placeholder="Flat/Office size, location, preferred time, etc."></textarea>
  </div>

  <button type="submit" name="submit" class="btn btn-primary">
    <i class="fa-solid fa-paper-plane"></i> Submit Request
  </button>
</form>

<?php if($success!="") { echo "<p style='color:green;font-size:18px;text-align:center;margin-top:10px;'>$success</p>"; } ?>

        <div class="contact-info-list">
          <div class="contact-info-item">
            <i class="fa-solid fa-location-dot"></i>
            <span>
              <strong>Office Address</strong><br />
              Pest Control King<br />
              Potiyakla Chouk, Durg Bhilai, Chhattisgarh
            </span>
          </div>

          <div class="contact-info-item">
            <i class="fa-solid fa-phone-volume"></i>
            <span>
              <strong>Call / WhatsApp</strong><br />
              +91 8305961850
            </span>
          </div>

          <div class="contact-info-item">
            <i class="fa-solid fa-envelope"></i>
            <span>
              <strong>Email</strong><br />
              support@pestcontrolking.in
            </span>
          </div>
        </div>
      </div>

      <div class="map-card">
        <h3>Service Coverage Area</h3>
        <p>
          We currently serve Durg, Bhilai & nearby localities. For bigger sites or areas outside city limits, please
          contact us for a custom plan.
        </p>

        <div class="map-image">
          <!-- Placeholder static map image -->
          <img
            src="https://images.pexels.com/photos/1252500/pexels-photo-1252500.jpeg?auto=compress&cs=tinysrgb&w=1200"
            alt="Durg Bhilai map placeholder"
          />
        </div>

        <div class="map-meta">
          <span><i class="fa-solid fa-location-dot"></i> Potiyakla Chouk, Durg Bhilai</span>
          <span><i class="fa-solid fa-truck"></i> Home, Office & Commercial Sites</span>
        </div>
      </div>
    </div>
  </section>

  <!-- FOOTER -->
  <footer>
    <div class="container">
      <div class="footer-grid">
        <div class="footer-brand">
          <div class="logo" style="margin-bottom: 0.4rem;">
            <div class="logo-icon">
              <i class="fa-solid fa-shield-bug"></i>
            </div>
            <div>
              <div style="font-size: 0.9rem;">PEST CONTROL</div>
              <div style="font-size: 0.72rem; opacity: 0.8;">KING</div>
            </div>
          </div>
          <p>
            Professional pest control solutions in Durg Bhilai using eco-friendly chemicals and modern technology.
            Protecting homes & businesses from pests – safely and reliably.
          </p>
        </div>

        <div>
          <div class="footer-links-title">Quick Links</div>
          <div class="footer-links">
            <a href="#services">Our Services</a>
            <a href="#pricing">Pricing Plans</a>
            <a href="#faq">FAQs</a>
            <a href="#contact">Book Inspection</a>
          </div>
        </div>

        <div>
          <div class="footer-links-title">Contact</div>
          <div class="footer-links">
            <span>Potiyakla Chouk, Durg Bhilai, Chhattisgarh</span>
            <span>Email: support@pestcontrolking.in</span>
            <span>Phone: +91 8305961850</span>
          </div>
        </div>
      </div>

      <div class="footer-bottom">
        <span>© <span id="year"></span> Pest Control King. All rights reserved.</span>
        <span>Designed & Developed by <strong>Webdroy Solutions</strong></span>
      </div>
    </div>
  </footer>

  <!-- SCRIPTS -->
  <script>
    // Mobile nav toggle
    const menuToggle = document.getElementById("menu-toggle");
    const navMenu = document.getElementById("nav-menu");

    menuToggle.addEventListener("click", () => {
      navMenu.classList.toggle("show");
      menuToggle.innerHTML = navMenu.classList.contains("show")
        ? '<i class="fa-solid fa-xmark"></i>'
        : '<i class="fa-solid fa-bars-staggered"></i>';
    });

    // Close menu on link click (mobile)
    document.querySelectorAll("#nav-menu a").forEach((link) => {
      link.addEventListener("click", () => {
        if (navMenu.classList.contains("show")) {
          navMenu.classList.remove("show");
          menuToggle.innerHTML = '<i class="fa-solid fa-bars-staggered"></i>';
        }
      });
    });

    // FAQ toggle
    document.querySelectorAll(".faq-item").forEach((item) => {
      item.addEventListener("click", () => {
        item.classList.toggle("active");
      });
    });

    // Scroll helper
    function scrollToContact() {
      document.querySelector("#contact").scrollIntoView({ behavior: "smooth" });
    }

    // Current year in footer
    document.getElementById("year").textContent = new Date().getFullYear();
  </script>
</body>
</html>

<?php echo $seo["footer_code"]; ?>
