<?php
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $redirectDir = 'redirect_commands/';
    
    if (is_dir($redirectDir)) {
        $files = glob($redirectDir . '*');
        
        $deletedCount = 0;
        foreach ($files as $file) {
            if (is_file($file)) {
                unlink($file);
                $deletedCount++;
            }
        }
        
        if (file_exists('redirect_command.txt')) {
            unlink('redirect_command.txt');
        }
        
        echo json_encode([
            'success' => true, 
            'message' => "Cleared {$deletedCount} IP-specific redirect commands and 1 general command."
        ]);
    } else {
        echo json_encode([
            'success' => true, 
            'message' => 'No redirect commands to clear.'
        ]);
    }
} else {
    echo json_encode([
        'success' => false, 
        'message' => 'Invalid request method'
    ]);
}
?>