<?php
header('Content-Type: application/json');

$clientIP = $_SERVER['REMOTE_ADDR'] ?? '';

$sanitizedIP = str_replace(':', '_', $clientIP);
$sanitizedIP = preg_replace('/[^a-zA-Z0-9._-]/', '_', $sanitizedIP);

$ipRedirectFile = 'redirect_commands/' . $sanitizedIP . '.txt';
$generalRedirectFile = 'redirect_command.txt';
$destination = null;

if (file_exists($ipRedirectFile)) {
    $command = trim(file_get_contents($ipRedirectFile));
    $destination = $command;
    
    unlink($ipRedirectFile);
}
elseif (file_exists($generalRedirectFile)) {
    $command = trim(file_get_contents($generalRedirectFile));
    $destination = $command;
    
    unlink($generalRedirectFile);
}

if ($destination) {
    $isUrl = (strpos($destination, 'http://') === 0 || strpos($destination, 'https://') === 0);
    
    echo json_encode(array(
        'redirect' => true,
        'destination' => $destination,
        'is_url' => $isUrl,
        'ip' => $clientIP
    ));
} else {
    echo json_encode(array(
        'redirect' => false,
        'destination' => null,
        'is_url' => false,
        'ip' => $clientIP
    ));
}
?>