<?php
// ------- Global Debug Mode -------
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Log file path
ini_set("log_errors", 1);
ini_set("error_log", __DIR__ . "/../error.log");

// start session if not already
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$isLoggedIn = isset($_SESSION['user_id']);
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>FastTag Recharge Panel</title>

<!-- Tailwind CSS CDN -->
<script src="https://cdn.tailwindcss.com"></script>

</head>

<body class="bg-gray-100 font-sans">

<!-- NAVBAR -->
<header class="bg-white shadow-md sticky top-0 z-50">
  <div class="container mx-auto px-4 py-4 flex justify-between items-center">

     <h1 class="text-2xl font-extrabold text-blue-600 tracking-wide">
         FastTag Service
     </h1>

     <nav class="hidden md:flex gap-6 text-gray-700 font-medium">
        <?php if($isLoggedIn): ?>

            <a href="/fastag-panel/public/dashboard.php" class="hover:text-blue-600 transition">Dashboard</a>
            <a href="/fastag-panel/public/wallet.php" class="hover:text-blue-600 transition">Wallet</a>
            <a href="/fastag-panel/public/recharge.php" class="hover:text-blue-600 transition">Recharge</a>
            <a href="/fastag-panel/public/history.php" class="hover:text-blue-600 transition">History</a>
            <a href="/fastag-panel/public/profile.php" class="hover:text-blue-600 transition">Profile</a>

            <a href="/fastag-panel/public/logout.php" class="bg-red-500 text-white px-4 py-1 rounded shadow hover:bg-red-600 transition">
                Logout
            </a>

        <?php else: ?>

            <a href="/fastag-panel/public/index.php" class="hover:text-blue-600 transition">Home</a>
            <a href="/fastag-panel/public/login.php" class="hover:text-blue-600 transition">Login</a>
            <a href="/fastag-panel/public/register.php" class="hover:text-blue-600 transition">Register</a>

        <?php endif; ?>
     </nav>

  </div>
</header>

<main class="container mx-auto px-4 py-6">
