<?php
session_start();
include "../../app/db.php";

if (!isset($_SESSION['user_id']) || $_SESSION['role'] != 'admin') {
    header("Location: ../login.php");
    exit();
}

include "header.php";

$users = mysqli_query($conn, "SELECT * FROM users WHERE role='user' ORDER BY id DESC");
?>

<h2 class="text-2xl font-bold mb-6">All Users</h2>

<table class="w-full bg-white shadow rounded-xl overflow-hidden">
<tr class="bg-gray-200">
   <th class="p-3">Name</th>
   <th class="p-3">Mobile</th>
   <th class="p-3">Email</th>
   <th class="p-3">Balance</th>
   <th class="p-3">Date</th>
</tr>

<?php while($u = mysqli_fetch_assoc($users)): ?>
<tr class="border-b hover:bg-gray-50">
   <td class="p-3"><?= $u['name'] ?></td>
   <td class="p-3"><?= $u['mobile'] ?></td>
   <td class="p-3"><?= $u['email'] ?></td>
   <td class="p-3 font-bold text-green-600">₹ <?= $u['balance'] ?></td>
   <td class="p-3"><?= $u['created_at'] ?></td>
</tr>
<?php endwhile; ?>
</table>

<?php include "../footer.php"; ?>
