<?php
session_start();
include "../../app/db.php";

if (!isset($_SESSION['user_id']) || $_SESSION['role'] != 'admin') {
    header("Location: ../login.php");
    exit();
}

include "header.php";
$txns = mysqli_query($conn, "SELECT wallet_transactions.*, users.name FROM wallet_transactions 
                             JOIN users ON users.id = wallet_transactions.user_id
                             ORDER BY wallet_transactions.id DESC");
?>

<h2 class="text-2xl font-bold mb-6">All Transactions</h2>

<table class="w-full bg-white shadow rounded-xl overflow-hidden">
<tr class="bg-gray-200">
   <th class="p-3">User</th>
   <th class="p-3">Amount</th>
   <th class="p-3">Type</th>
   <th class="p-3">Description</th>
   <th class="p-3">Status</th>
   <th class="p-3">Date</th>
</tr>

<?php while($t = mysqli_fetch_assoc($txns)): ?>
<tr class="border-b hover:bg-gray-50">
   <td class="p-3"><?= $t['name'] ?></td>
   <td class="p-3 font-bold">₹ <?= $t['amount'] ?></td>
   <td class="p-3"><?= $t['type'] ?></td>
   <td class="p-3"><?= $t['description'] ?></td>
   <td class="p-3 text-green-600"><?= $t['status'] ?></td>
   <td class="p-3"><?= $t['created_at'] ?></td>
</tr>
<?php endwhile; ?>
</table>

<?php include "../footer.php"; ?>
