<?php
session_start();
include "../../app/db.php";

// admin security check
if (!isset($_SESSION['user_id']) || $_SESSION['role'] != 'admin') {
    header("Location: ../login.php");
    exit();
}

include "header.php";
?>

<h2 class="text-3xl font-bold mb-6">Admin Dashboard</h2>

<?php 
$total_users = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as total FROM users WHERE role='user'"))['total'];
$total_balance = mysqli_fetch_assoc(mysqli_query($conn, "SELECT SUM(balance) as total FROM users WHERE role='user'"))['total'];
$total_txn = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as total FROM wallet_transactions"))['total'];
$total_recharges = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as total FROM recharges"))['total'];
?>

<div class="grid grid-cols-1 md:grid-cols-4 gap-6">

<div class="bg-white shadow p-6 rounded-xl text-center">
   <h3 class="text-gray-600">Total Users</h3>
   <p class="text-3xl font-bold text-blue-600"><?= $total_users ?></p>
</div>

<div class="bg-white shadow p-6 rounded-xl text-center">
   <h3 class="text-gray-600">Total Balance</h3>
   <p class="text-3xl font-bold text-green-600">₹ <?= $total_balance ?? 0 ?></p>
</div>

<div class="bg-white shadow p-6 rounded-xl text-center">
   <h3 class="text-gray-600">Transactions</h3>
   <p class="text-3xl font-bold text-purple-600"><?= $total_txn ?></p>
</div>

<div class="bg-white shadow p-6 rounded-xl text-center">
   <h3 class="text-gray-600">Recharges</h3>
   <p class="text-3xl font-bold text-red-600"><?= $total_recharges ?></p>
</div>

</div>

<?php include "../footer.php"; ?>
